/* - FCDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.FrequencyCounterPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;
import javax.swing.JButton;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FCDetachListener implements DetachListener {

    private JFrame appFrame;
    private JPanel frequencyPanel;
    private JComboBox channelCmb;
    private JComboBox filterCmb;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numChannelsTxt;
    private JCheckBox enableChk;
    private JTextField timeoutTxt;
    private JButton setTimeoutBtn;
    private JTextField countTxt;
    private JTextField timeTxt;
    private JTextField frequencyTxt;
    private JTextField totalCountTxt;
    private JTextField totalTimeTxt;
    private JButton resetTotalTimeAndCountBtn;

    public FCDetachListener(JFrame appFrame, JPanel frequencyPanel, JComboBox channelCmb, JComboBox filterCmb, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numChannelsTxt, JCheckBox enableChk, JTextField timeoutTxt, JButton setTimeoutBtn, JTextField countTxt,
            JTextField timeTxt, JTextField frequencyTxt, JTextField totalCountTxt, JTextField totalTimeTxt, JButton resetTotalTimeAndCountBtn) {
        this.appFrame = appFrame;
        this.frequencyPanel = frequencyPanel;
        this.channelCmb = channelCmb;
        this.filterCmb = filterCmb;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numChannelsTxt = numChannelsTxt;
        this.enableChk = enableChk;
        this.timeoutTxt = timeoutTxt;
        this.setTimeoutBtn = setTimeoutBtn;
        this.countTxt = countTxt;
        this.timeTxt = timeTxt;
        this.frequencyTxt = frequencyTxt;
        this.totalCountTxt = totalCountTxt;
        this.totalTimeTxt = totalTimeTxt;
        this.resetTotalTimeAndCountBtn = resetTotalTimeAndCountBtn;
    }

    public void detached(DetachEvent de) {
        try {
            FrequencyCounterPhidget detached = (FrequencyCounterPhidget) de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numChannelsTxt.setText("");

            enableChk.setSelected(false);
            enableChk.setVisible(false);
            enableChk.setEnabled(false);

            timeoutTxt.setText("");
            timeoutTxt.setVisible(false);
            timeoutTxt.setEditable(false);
            timeoutTxt.setEnabled(false);

            setTimeoutBtn.setVisible(false);
            setTimeoutBtn.setEnabled(false);

            countTxt.setText("");
            countTxt.setVisible(false);
            countTxt.setEnabled(false);

            timeTxt.setText("");
            timeTxt.setVisible(false);
            timeTxt.setEnabled(false);

            frequencyTxt.setText("");
            frequencyTxt.setVisible(false);
            frequencyTxt.setEnabled(false);

            totalCountTxt.setText("");
            totalCountTxt.setVisible(false);
            totalCountTxt.setEnabled(false);

            totalTimeTxt.setText("");
            totalTimeTxt.setVisible(false);
            totalTimeTxt.setEnabled(false);

            resetTotalTimeAndCountBtn.setVisible(false);
            resetTotalTimeAndCountBtn.setEnabled(false);

            channelCmb.setEnabled(false);
            channelCmb.removeAllItems();

            filterCmb.setEnabled(false);
            filterCmb.removeAllItems();

            frequencyPanel.setVisible(false);

            appFrame.setSize(357, 311);

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
